-- Creates the measure_matrix_ip table based on measure_matrix table;
--  specifies the PreTechID or the StdTechID = 'IP' when the primary keys match the primary keys in the TechInit table
-- This table is used to calculate Measure energy impacts by specifying the technology (or IP) results that need to be compared
--  to determine the energy savings for each measure instance.
-- Only the 7 cases described below are accounted for; other scenarios could be possible with new measure definitions.
DROP TABLE IF EXISTS support."measure_matrix_ip";
CREATE TABLE support.measure_matrix_ip
 AS (SELECT * FROM (
 -- Case 1: PreTechID = NULL, StdTechID Not in IP:
 (SELECT "MeasureID",
         bldgtype,
         bldgvint,
         bldgloc,
         bldghvac,
         tstat,
         "PreTechID",
         "PreSimQual",
         "StdTechID",
         "StdSimQual", 
         "MsrTechID",
         "MsrSimQual"
  FROM support.measure_matrix 
      WHERE bldgtype in ('SFm','MFm','DMo') AND 
       "PreTechID" IS NULL and 
       "StdTechID" IS NOT NULL and 
       "StdTechID"||bldgtype||bldgvint||bldgloc||bldghvac NOT IN 
        (
        SELECT techid||bldgtype||bldgvint||bldgloc||bldghvac as stdisip
         FROM (select bldgtype, bldgvint, bldgloc,bldghvac, "StdTechID" as techid from measure_matrix where "StdTechID" IS NOT NULL
          INTERSECT
         SELECT "BldgType" as bldgtype, "BldgVint" as bldgvint, "BldgLoc" as bldgloc, "BldgHVAC" as bldghvac, "TechID" as techid from "expTechInit"	
              ) a where bldgtype in ('SFm','MFm','DMo')
        ) 
  )
UNION
 -- Case 2: PreTechID = NULL, StdTechID in IP:
 (SELECT "MeasureID",
         bldgtype,
         bldgvint,
         bldgloc,
         bldghvac,
         tstat,
         "PreTechID",
         "PreSimQual",
         'IP', 'None',
         "MsrTechID",
         "MsrSimQual"
  FROM support.measure_matrix 
      WHERE bldgtype in ('SFm','MFm','DMo') AND 
       "PreTechID" IS NULL and 
       "StdTechID" IS NOT NULL and 
       "StdTechID"||bldgtype||bldgvint||bldgloc||bldghvac IN 
        (
        SELECT techid||bldgtype||bldgvint||bldgloc||bldghvac as stdisip
         FROM (select bldgtype, bldgvint, bldgloc,bldghvac, "StdTechID" as techid from measure_matrix where "StdTechID" IS NOT NULL
          INTERSECT
         SELECT "BldgType" as bldgtype, "BldgVint" as bldgvint, "BldgLoc" as bldgloc, "BldgHVAC" as bldghvac, "TechID" as techid from "expTechInit"	
              ) a where bldgtype in ('SFm','MFm','DMo')
        ) 
  )
UNION

-- Case 3: PreTechID in IP, StdTechID is NULL:
 (SELECT "MeasureID",
         bldgtype,
         bldgvint,
         bldgloc,
         bldghvac,
         tstat,
         'IP', 'None',
         "StdTechID",
         "StdSimQual", 
         "MsrTechID",
         "MsrSimQual"
  FROM support.measure_matrix 
      WHERE bldgtype in ('SFm','MFm','DMo') AND 
       "PreTechID" IS NOT NULL and 
       "PreTechID"||bldgtype||bldgvint||bldgloc||bldghvac IN 
        (
        SELECT techid||bldgtype||bldgvint||bldgloc||bldghvac as preisip
         FROM (select bldgtype, bldgvint, bldgloc,bldghvac, "PreTechID" as techid from measure_matrix where "PreTechID" IS NOT NULL
          INTERSECT
         SELECT "BldgType" as bldgtype, "BldgVint" as bldgvint, "BldgLoc" as bldgloc, "BldgHVAC" as bldghvac, "TechID" as techid from "expTechInit"	
              ) a where bldgtype in ('SFm','MFm','DMo')
        ) AND
       "StdTechID" IS NULL
  )
UNION

-- Case 4: PreTechID in IP, StdTechID in IP:
 (SELECT "MeasureID",
         bldgtype,
         bldgvint,
         bldgloc,
         bldghvac,
         tstat,
         'IP', 'None',
         'IP', 'None',
         "MsrTechID",
         "MsrSimQual"
  FROM support.measure_matrix 
      WHERE bldgtype in ('SFm','MFm','DMo') AND 
       "PreTechID" IS NOT NULL and 
       "PreTechID"||bldgtype||bldgvint||bldgloc||bldghvac IN 
        (
        SELECT techid||bldgtype||bldgvint||bldgloc||bldghvac as preisip
         FROM (select bldgtype, bldgvint, bldgloc,bldghvac, "PreTechID" as techid from measure_matrix where "PreTechID" IS NOT NULL
          INTERSECT
         SELECT "BldgType" as bldgtype, "BldgVint" as bldgvint, "BldgLoc" as bldgloc, "BldgHVAC" as bldghvac, "TechID" as techid from "expTechInit"	
              ) a where bldgtype in ('SFm','MFm','DMo')
        ) AND
       "StdTechID" IS NOT NULL and 
       "StdTechID"||bldgtype||bldgvint||bldgloc||bldghvac IN 
        (
        SELECT techid||bldgtype||bldgvint||bldgloc||bldghvac as stdisip
         FROM (select bldgtype, bldgvint, bldgloc,bldghvac, "StdTechID" as techid from measure_matrix where "StdTechID" IS NOT NULL
          INTERSECT
         SELECT "BldgType" as bldgtype, "BldgVint" as bldgvint, "BldgLoc" as bldgloc, "BldgHVAC" as bldghvac, "TechID" as techid from "expTechInit"	
              ) a where bldgtype in ('SFm','MFm','DMo')
        ) 
  )
UNION
-- Case 5: PreTechID in IP, StdTechID not in IP:
 (SELECT "MeasureID",
         bldgtype,
         bldgvint,
         bldgloc,
         bldghvac,
         tstat,
         'IP', 'None',
         "StdTechID",
         "StdSimQual", 
         "MsrTechID",
         "MsrSimQual"
  FROM support.measure_matrix 
      WHERE bldgtype in ('SFm','MFm','DMo') AND 
       "PreTechID" IS NOT NULL and 
       "PreTechID"||bldgtype||bldgvint||bldgloc||bldghvac IN 
        (
        SELECT techid||bldgtype||bldgvint||bldgloc||bldghvac as preisip
         FROM (select bldgtype, bldgvint, bldgloc,bldghvac, "PreTechID" as techid from measure_matrix where "PreTechID" IS NOT NULL
          INTERSECT
         SELECT "BldgType" as bldgtype, "BldgVint" as bldgvint, "BldgLoc" as bldgloc, "BldgHVAC" as bldghvac, "TechID" as techid from "expTechInit"	
              ) a where bldgtype in ('SFm','MFm','DMo')
        ) AND
       "StdTechID" IS NOT NULL and 
       "StdTechID"||bldgtype||bldgvint||bldgloc||bldghvac NOT IN 
        (
        SELECT techid||bldgtype||bldgvint||bldgloc||bldghvac as stdisip
         FROM (select bldgtype, bldgvint, bldgloc,bldghvac, "StdTechID" as techid from measure_matrix where "StdTechID" IS NOT NULL
          INTERSECT
         SELECT "BldgType" as bldgtype, "BldgVint" as bldgvint, "BldgLoc" as bldgloc, "BldgHVAC" as bldghvac, "TechID" as techid from "expTechInit"	
              ) a where bldgtype in ('SFm','MFm','DMo')
        ) 
  )
UNION
-- Case 6: PreTechID not in IP, StdTechID is NULL:
 (SELECT "MeasureID",
         bldgtype,
         bldgvint,
         bldgloc,
         bldghvac,
         tstat,
         "PreTechID",
         "PreSimQual",
         "StdTechID",
         "StdSimQual", 
         "MsrTechID",
         "MsrSimQual"
  FROM support.measure_matrix 
      WHERE bldgtype in ('SFm','MFm','DMo') AND 
       "PreTechID" IS NOT NULL and 
       "PreTechID"||bldgtype||bldgvint||bldgloc||bldghvac NOT IN 
        (
        SELECT techid||bldgtype||bldgvint||bldgloc||bldghvac as preisip
         FROM (select bldgtype, bldgvint, bldgloc,bldghvac, "PreTechID" as techid from measure_matrix where "PreTechID" IS NOT NULL
          INTERSECT
         SELECT "BldgType" as bldgtype, "BldgVint" as bldgvint, "BldgLoc" as bldgloc, "BldgHVAC" as bldghvac, "TechID" as techid from "expTechInit"	
              ) a where bldgtype in ('SFm','MFm','DMo')
        ) AND
       "StdTechID" IS NULL
  )
UNION
-- Case 7: PreTechID not in IP, StdTechID not in IP:
 (SELECT "MeasureID",
         bldgtype,
         bldgvint,
         bldgloc,
         bldghvac,
         tstat,
         "PreTechID",
         "PreSimQual",
         "StdTechID",
         "StdSimQual", 
         "MsrTechID",
         "MsrSimQual"
  FROM support.measure_matrix 
      WHERE bldgtype in ('SFm','MFm','DMo') AND 
       "PreTechID" IS NOT NULL and 
       "PreTechID"||bldgtype||bldgvint||bldgloc||bldghvac NOT IN 
        (
        SELECT techid||bldgtype||bldgvint||bldgloc||bldghvac as preisip
         FROM (select bldgtype, bldgvint, bldgloc,bldghvac, "PreTechID" as techid from measure_matrix where "PreTechID" IS NOT NULL
          INTERSECT
         SELECT "BldgType" as bldgtype, "BldgVint" as bldgvint, "BldgLoc" as bldgloc, "BldgHVAC" as bldghvac, "TechID" as techid from "expTechInit"	
              ) a where bldgtype in ('SFm','MFm','DMo')
        ) AND
       "StdTechID" IS NOT NULL and 
       "StdTechID"||bldgtype||bldgvint||bldgloc||bldghvac NOT IN 
        (
        SELECT techid||bldgtype||bldgvint||bldgloc||bldghvac as stdisip
         FROM (select bldgtype, bldgvint, bldgloc,bldghvac, "StdTechID" as techid from measure_matrix where "StdTechID" IS NOT NULL
          INTERSECT
         SELECT "BldgType" as bldgtype, "BldgVint" as bldgvint, "BldgLoc" as bldgloc, "BldgHVAC" as bldghvac, "TechID" as techid from "expTechInit"	
              ) a where bldgtype in ('SFm','MFm','DMo')
        ) 
  )

) foo
)